/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPGPException.cpp,v 1.7 2001/01/25 22:10:46 jeffc Exp $
____________________________________________________________________________*/

#include <sstream>

#include "CPGPException.h"

#if PGP_MACINTOSH
#	include <TextUtils.h>
#	include <UException.h>
#endif


CPGPException::CPGPException(
	PGPError		inError,
	const char *	inErrorString)
{
	SetError(inError, inErrorString);
}



#if PGP_MACINTOSH
CPGPException::CPGPException(
	PGPError		inError,
	const uchar *	inErrorString)
{
	char temp[256];
	
	::BlockMoveData(&inErrorString[1], temp, inErrorString[0]);
	temp[inErrorString[0]] = 0;
	SetError(inError, temp);
}
#endif



CPGPException::~CPGPException()
{
}



	void
CPGPException::SetError(
	PGPError		inError,
	const char *	inErrorString)
{
	mError = inError;
	if (inErrorString != 0) {
		mErrorString = inErrorString;
	} else {
		ConvertPGPErrorToString(inError, &mErrorString);
	}
}



#if PGP_DEBUG
	void
CPGPException::DebugMessage(
	const char *	inFile,
	int				inLine) const
{
	if (! IsCancelError()) {
		ostringstream	message;

		message << "CPGPException: " << mError << " (" << mErrorString << ") File: " << inFile
			<< " Line: " << inLine;
		DumpPGPDebugMessage(message.str().c_str());
	}
}
#endif



COSException::COSException(
	PGPInt32		inError,
	const char *	inErrorString)
		:	CPGPException(ConvertOSErrorToPGPError(inError), inErrorString), mOSError(inError)
{	
}



#if PGP_MACINTOSH
COSException::COSException(
	PGPInt32		inError,
	const uchar *	inErrorString)
		:	CPGPException(ConvertOSErrorToPGPError(inError), inErrorString),
			mOSError(inError)
{
}
#endif



COSException::~COSException()
{
}



#if PGP_DEBUG
	void
COSException::DebugMessage(
	const char *	inFile,
	int				inLine) const
{
	if (! IsCancelError()) {
		ostringstream	message;

		message << "COSException: " << mOSError << " File: " << inFile << " Line: " << inLine;
		DumpPGPDebugMessage(message.str().c_str());
	}
}
#endif



StPGPExceptionConverter::StPGPExceptionConverter()
	:	mException(0)
{
	Convert();
}



StPGPExceptionConverter::~StPGPExceptionConverter()
{
	delete mException;
}


	void
StPGPExceptionConverter::Convert()
{
	try {
		throw;
	}
	
	catch (COSException & error) {
		mException = new COSException(error);
	}
	
	catch (CPGPException & error) {
		mException = new CPGPException(error);
	}
	
#if __PowerPlant__
	catch (LException & error) {
		switch (error.GetErrorCode()) {
			case err_NilPointer:
			{
				mException = new CPGPException(kPGPError_BadMemAddress);
			}
			break;
			
			
			case err_AssertFailed:
			{
				mException = new CPGPException(kPGPError_AssertFailed);
			}
			break;
			
			
			default:
			{
				mException = new COSException(error.GetErrorCode());
			}
			break;
		}
		
	}
#endif
	
	catch (logic_error & error) {
		mException = new CPGPException(kPGPError_BadParams);
	}
	
	catch (bad_alloc & error) {
		mException = new CPGPException(kPGPError_OutOfMemory);
	}
	
	catch (...) {
		mException = new CPGPException(kPGPError_UnknownError);
	}
}